---
Note type: Reference
tags:
  - ZoteroReference
  - "#REFERENCE"
Reference type: journalArticle
Bib_ref: "Spicer A, Alvesson M and Kärreman D (2009) Critical performativity: The unfinished business of critical management studies. _Human Relations_ 62(4): 537–560."
Title: "Critical performativity: The unfinished business of critical management studies"
Authors: André Spicer, Mats Alvesson, Dan Kärreman
Year: 2009-01-01T00:00:00+00:00
Journal-publisher: Human Relations
Read: Read
Related areas:
  - "[[Research]]"
  - "[[Teaching]]"
Related projects:
  - "[[Paper X]]"
  - "[[SOC101 Introduction to Sociology Course]]"
Related tasks: 
Related references: 
Related zettels: 
Related meeting notes: 
Related resources: 
Related people:
  - "[[André Spicer]]"
  - "[[Mats Alvesson]]"
  - "[[Dan Kärreman]]"
aliases:
  - '"Critical performativity: The unfinished business of critical management studies"'
Creation date: 2024-05-27
Last modified: 2024-05-27
---

## Overview

### Context

### RQ

### Thesis

advocates a [[performative CMS]]
- “instead of fighting against performativity, CMS should seek to become more performative.” ([[Spicer et al. 2009]], p. 554)
- “The central task of CMS should be to actively and pragmatically intervene in specific debates about management and encourage progressive forms of management.” ([[Spicer et al. 2009]], p. 537)
- “We reject the idea that CMS is best characterized as nonor anti-performative (Fournier & Grey, 2000; Grey & Willmott, 2005). Instead, we suggest that critical performativity is a more ‘constructive’ direction for CMS.” ([[Spicer et al. 2009]], p. 538)

### Methodology

### Theoretical approach

### Findings

### Contributions

### Striking points

### Further research suggested

### My ideas/responses

### Useful references

- Meyerson, D. Tempered radicals: How everyday leaders inspire change at work. Boston, MA: Harvard Business School Press, 2001.

## Summary

### [[critical performativity]]

- “critical performativity involves active and subversive intervention into managerial discourses and practices.” ([[Spicer et al. 2009]], p. 538)
- “This is achieved through affirmation, care, pragmatism, engagement with potentialities, and a normative orientation.” ([[Spicer et al. 2009]], p. 538)
- “Critical performativity also moves beyond the cynicism that pervades CMS. It does so by recognizing that critique must involve an affirmative movement along-side the negative movement that seems to predominate in CMS today” ([[Spicer et al. 2009]], p. 538)

### What is [[Critical Management Studies]] for?

- creating far-reaching “emancipatory social change” (e.g. Knights & Willmott, 1987; Stablein & Nord, 1985)
- [[micro-emancipation]] - [[Alvesson & Willmott 1992]]
    - “Micro-emancipations involve specific and focused attempts to create spaces of autonomy among institutionalized relations of power. This involves crafting spaces of freedom from the ‘bottom up’. This often occurs through the micro-transformations of aspects of everyday life.” ([[Spicer et al. 2009]], p. 553)
    - “Through engaging with and tracking these actions, CMS will be able to show that many alternatives to current systems of managerial domination and exploitation currently exist and do indeed work (Gibson-Graham, 1996).” ([[Spicer et al. 2009]], p. 554)
    - “CMS might be able to act as a kind of emissary between the various micro-emancipations in organizations. This might involve ‘translating’ (Czarniawska & Sevon, 2005) microemancipations from one context into other contexts. It might also involve drawing out links or ‘articulations’ between a series of micro-emancipations in order for them to gain greater collective power (Willmott, 2006).” ([[Spicer et al. 2009]], p. 554)

### The [[anti-performativity]] debate

- [[Fournier & Grey 2000]]
    - “CMS should resist attempts to ‘develop and celebrate knowledge which contributes to the production of maximum output for minimum input; it involves inscribing knowledge within means–ends calculation’” ([[Spicer et al. 2009]], p. 540)
    - “de-naturalization” - ‘deconstructing the “reality” of organizational life or “truthfulness” of organizational knowledge by exposing its “unnaturalness” or irrationality’” ([[Spicer et al. 2009]], p. 540)
    - “reflexive” - “challenge the implicit assumption around positivism that is often taken for granted in critical work.” ([[Spicer et al. 2009]], p. 540)
- [[Grey & Willmott 2005)]]
    - “CMS ‘should not involve an antagonistic attitude towards all forms of “performing”, only to forms of action in which there is a means–ends calculus that pays little or no attention to the question of ends’ (p. 7).” ([[Spicer et al. 2009]], p. 540)
- [[Anti-performativity]] defines performativity as “‘inscribing knowledge within means–ends calculations’ (Fournier & Grey, 2000: 17)” ([[Spicer et al. 2009]], p. 541)
    - “This definition relies on Lyotard’s (1984) understanding of performativity as ‘the optimization of the global relationship between input and output’” ([[Spicer et al. 2009]], p. 541)
- Problems with this anti-performative version of CMS:
    - “anti-performativity in CMS conflicts with attempts to promote social change. Fournier and Grey (2000: 22) themselves, note that CMS researchers can become preoccupied ‘with the grounds and “righteousness” of our critique’ which ‘distract(s) us from engaging with organizational practices and participants’ (see also Anthony, 1998).” ([[Spicer et al. 2009]], p. 541)
    - “by placing itself into a consistently negative position, CMS is unable to put forward a firm claim about what it actually wants and desires. By perpetually setting itself up in a position of critical judgement, all CMS is able to do is go through the motions of demolition and destruction (for a parallel argument, see Latour, 2004). This destructive footing means that CMS finds it difficult, if not impossible, to begin to sketch out the kind of world that it might actually want (Böhm, 2005). Put bluntly, the practitioner of CMS is always able to tell us what is wrong with the organizations we have (they are capitalist, managerialist, patriarchal, imperialist, technocratic, dualist and so on) but when the question comes of what they would actually want, their rapid attack turns into a vague set of platitudes, pauses and vacillations.” ([[Spicer et al. 2009]], p. 542)
    - “by abdicating responsibility for managerial practice, CMS may have inadvertently helped to lay the ground for the increasing dominance of financial approaches.” ([[Spicer et al. 2009]], p. 542)

### [[performative CMS]]

- “we would like to suggest that performativity is not just about efficiency, but it also involves active intervention into discourse and practice.” ([[Spicer et al. 2009]], p. 543) ^555d08
- Performativity can involve “possibly subversive mobilizations and citations of previous performances” ([[Spicer et al. 2009]], p. 544) ^9dcef7
- “If CMS was to think of itself as a performative enterprise, its central aim would be to actively and subversively intervene in managerial discourse and practices.” ([[Spicer et al. 2009]], p. 544)
- #### five elements of a performative approach to CMS
    - _an affirmative stance_
        - “involves the practice of what Spivak (1999: 425) calls ‘critical intimacy’.” ([[Spicer et al. 2009]], p. 546)
    - _an ethic of care_
        - Care “is a basic debt we owe to all our fellow humans. But this debt comes with a significant dilemma of caring for actors’ views at the same time as we seek to challenge them. Arrogance and elitism is one risk. The other risk is accepting and legitimizing the social order. There is no lasting resolution of this dilemma. It must be practically and productively negotiated in an everyday fashion.” ([[Spicer et al. 2009]], p. 548)
        - “most current versions of CMS rely on an oppositional stance. In contrast, a critical-performative approach involves asking practical questions which care for participants’ views at the same time as seeking to challenge the same participants.” ([[Spicer et al. 2009]], p. 547)
        - “At the most basic level, this involves recognizing the right of participants to speak as rational, reflexive individuals.” ([[Spicer et al. 2009]], p. 548)
    - _a pragmatic orientation_
        - “A critical performative approach rejects attempts to present powerful systems as totally integrated, all powerful, singular entities (Latour, 2005). By treating these entities as such, we unwittingly continue to affirm the sovereignty and all-powerful nature of these systems and convince ourselves and, perhaps more importantly, others that they cannot be challenged or changed” ([[Spicer et al. 2009]], p. 549)
        - “This would involve ‘revolutionary reform’ (Unger, 1987) where we would seek to change management by making incremental incisions into particular processes.” ([[Spicer et al. 2009]], p. 550)
    - _attending to potentialities_
        - “Engaging with potentialities involves moving beyond critiquing contemporary management practices that actually exist and attempting to create a sense of what could be.” ([[Spicer et al. 2009]], p. 551)
             “This requires us to ask about the organization to come, rather than focusing on rejecting the organization that we currently have.” ([[Spicer et al. 2009]], p. 551)
        - “The exploration of [[heterotopias]] is one potential way of nurturing potentialities.” ([[Spicer et al. 2009]], p. 551) -  [[interstitial social transformation]]
            - “Heterotopias mean other places. They are spaces of play that encourage the exploration and imagination of alternative modes of being and doing (Hjorth, 2005).” ([[Spicer et al. 2009]], p. 551)
            - “A heterotopia presents a world that is not too distant from the world in which we dwell today. Because it is not too distant, a sense of hope and possibility is nurtured.” ([[Spicer et al. 2009]], p. 551)
            - “Heterotopias introduce touches of ‘realism’ by also acknowledging that problems, struggles and conflicts might also exist in this other-place.” ([[Spicer et al. 2009]], p. 551) - [[purity politics]]
        - [[tempered radicalism]] - [[Meyerson 2001]]
            - “how organizational activists seek to create these visions of other possible places in organizations.” ([[Spicer et al. 2009]], p. 552)
    - _a normative orientation_
        - “although a practitioner of CMS is quite happy to point to something being ‘bad’ or ‘problematic’, they are far less likely to be able to innumerate the political bases upon which they might consider something to be ‘good’. A performative CMS would take a step further and seek to innumerate and justify the claims around the political orientation of CMS (Böhm, 2005). It would be clear about what it wants, or at least debate it.” ([[Spicer et al. 2009]], p. 553)
        - “the choice between the [[tyranny of hierarchy]] and the [[tyranny of structurelessness]] is not an easy one to make. In order to make such choices, performative CMS might take advantage of normative resources within political philosophy (e.g. Kymlicka, 2001; Wolin, 2004). Here we do not seek to proscribe a singular set of criteria. Rather, we are gesturing towards the need to begin the debate about what these criteria may actually be and the potential costs and sacrifices involved.” ([[Spicer et al. 2009]], p. 553)